﻿//////////////////////////////////////////////
// Renderer.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkExport
{
	class Node ;
}

namespace nkGraphics
{
	class Buffer ;
	class Configuration ;
	class DataAllocator ;
	class Mesh ;
	class PostProcessPass ;
	class RenderQueue ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "RendererAbstractData.h"
#include "RendererSupportInfo.h"
#include "RenderingApi.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Renderer
	{
		public :
	
			// Constructor, destructor
			Renderer () noexcept ;
			virtual ~Renderer () ;

			// Getters
			virtual DataAllocator* getAllocator () const = 0 ;
			virtual RendererSupportInfo getRendererSupportInfo () const = 0 ;
			virtual nkMemory::UniquePtr<nkExport::Node> getStats () const = 0 ;
			virtual RendererAbstractData getInternalData () const ;
			RENDERING_API getRenderApi () const ;

			// Lifetime management
			virtual bool initialize (const Configuration& config) = 0 ;
			virtual bool initiateBuiltInShaders () = 0 ;
			virtual bool postGraphicSystemInit () = 0 ;
			virtual void prepareForRelease () = 0 ;
			virtual bool shutdown () = 0 ;

			// Flushing
			virtual void flushRendering () = 0 ;

			// Rendering steps
			virtual void preRenderRoutine () = 0 ;
			virtual void postRenderRoutine () = 0 ;

		protected :

			// Attributes
			RENDERING_API _renderApi ;
	} ;
}